function varargout = BS(varargin)
% BS MATLAB code for BS.fig
%      BS, by itself, creates a new BS or raises the existing
%      singleton*.
%
%      H = BS returns the handle to a new BS or the handle to
%      the existing singleton*.
%
%      BS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in BS.M with the given input arguments.
%
%      BS('Property','Value',...) creates a new BS or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before BS_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to BS_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help BS

% Last Modified by GUIDE v2.5 13-Sep-2013 13:42:56

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @BS_OpeningFcn, ...
                   'gui_OutputFcn',  @BS_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT
end


% --- Executes just before BS is made visible.
function BS_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to BS (see VARARGIN)
clear ngj Dj delay_jj NUM_FLOWS k gamma_ah gamma_ie gamma_ae g gmin gmax imax g1m_store period_store amp_store j1 j1max tspan;
clear aiiA_store AHL_store AHLe_store luxI_store dB;
axes(handles.axes1);
cla;
M1 = imread('S1.png');
imshow(M1);
axes(handles.axes2);
cla;
M3 = imread('S3.jpg');
imshow(M3);
handles.M3 = M3;
for i = 1:16
    if i == 6 || i == 13
        continue;
    end
    set(eval(strcat('handles.E', num2str(i))), 'string', char.empty(1,0));
end
% Choose default command line output for BS
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);
% UIWAIT makes BS wait for user response (see UIRESUME)
% uiwait(handles.BS);
end


% --- Outputs from this function are returned to the command line.
function varargout = BS_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;
end


% --- Executes on button press in pb1.
function pb1_Callback(hObject, eventdata, handles)
set(figure(BS), 'Visible', 'off');
set(figure(catalog), 'Visible', 'on');
% hObject    handle to pb1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- Executes on button press in pb4.
function pb4_Callback(hObject, eventdata, handles)
for i = 1:16
    if i == 6 || i == 13
        continue;
    end
    set(eval(strcat('handles.E', num2str(i))), 'string', char.empty(1,0));
end
% hObject    handle to pb4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- Executes on button press in pb2.
function pb2_Callback(hObject, eventdata, handles)
global AD1 AD;
guidata(hObject, handles);
AD1 = handles;
AD = handles;
E = 0;
for i = 1:16
    if i == 6
        continue;
    end
    temp1 = get(handles.E1, 'string');
    temp2 = get(handles.E14, 'string');
    if isempty(get(eval(strcat('handles.E', num2str(i))), 'string')) && strcmp(get(eval(strcat('handles.E', num2str(i))), 'Enable'), 'on') || ( str2double(temp1) == 0 && get(handles.C3, 'value')) || (str2double(temp2) == 0 && ~get(handles.C3, 'value'))
        E = 1;
        break;
    end
end
if E == 1
    sel = questdlg('Please set all the parameters (Cell density cannot equal to 0).', 'Attention', 'OK','OK');
    switch sel
        case 'OK'
            return;
    end
else
    sel = questdlg('Due to the different parameters, sometimes it will take more than 2 mins. Are you sure to continue?', 'Attention', 'Yes', 'No', 'No');
    switch sel
        case 'Yes'
            set(Choose, 'WindowStyle', 'modal');
        case 'No'
            return;
    end
end
% hObject    handle to pb2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- Executes on button press in pb3.
function pb3_Callback(hObject, eventdata, handles)
global ngj Dj delay_jj NUM_FLOWS k gamma_ah gamma_ie gamma_ae g gmin gmax Sint;
set(handles.E1, 'string', '0.3');
set(handles.E2, 'string', '20');%225
set(handles.E3, 'string', '35');  %421.875
set(handles.E4, 'string', '0.225');
set(handles.E5, 'string', '0.5');
set(handles.E7, 'string', '1.0');
set(handles.E8, 'string', '0.018');
set(handles.E9, 'string', '0');
set(handles.E10, 'string', '1.8');
set(handles.E11, 'string', '0.6');
set(handles.E12, 'string', '1.5');
set(handles.E14,'string', '0.1');
set(handles.E15, 'string', '0.9');
set(handles.E16, 'string', '0.25');
E1_Callback(hObject, eventdata, handles);
E2_Callback(hObject, eventdata, handles);
E3_Callback(hObject, eventdata, handles);
E4_Callback(hObject, eventdata, handles);
E5_Callback(hObject, eventdata, handles);
E7_Callback(hObject, eventdata, handles);
E8_Callback(hObject, eventdata, handles);
E9_Callback(hObject, eventdata, handles);
E10_Callback(hObject, eventdata, handles);
E11_Callback(hObject, eventdata, handles);
E12_Callback(hObject, eventdata, handles);
E14_Callback(hObject, eventdata, handles);
E15_Callback(hObject, eventdata, handles);
E16_Callback(hObject, eventdata, handles);
% ngj=[1.5];
% ng=ngj(jj);
% c1=1.0*ng;  gj=[0.012]*c1; gamma_ahjj=[0.15]*c1;
% c2=1.0*ng;  fj=[0.3]*c2; gamma_aejj=[150.0]*c2; gamma_iejj=[gamma_aejj*1.25]*c2;
% c3=1.0*ng;  bj=[0.5]*c3; kj=[1.0]*c3;
% c4=1.0*ng;  alphaj=[2500.0]*c4;  k1_jj=[0.0]*c4;
% 
set(handles.C2, 'Value', 1);
C2_Callback(hObject, eventdata, handles);
% gmin=0.00; gmax=3.0;
% NUM_FLOWS=5;
% g1m=[gmin:gmax/NUM_FLOWS:gmax 5.0];

set(handles.C1, 'Value', 0);
C1_Callback(hObject, eventdata, handles);

set(handles.C3, 'Value',1);
C3_Callback(hObject, eventdata, handles);
str = 'This example provides the parameters which are the same in the references.';
set(handles.text5, 'string', str);
% hObject    handle to pb3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --------------------------------------------------------------------
function menu1_Callback(hObject, eventdata, handles)
% hObject    handle to menu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --------------------------------------------------------------------
function menu4_Callback(hObject, eventdata, handles)
% hObject    handle to menu4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --------------------------------------------------------------------
function menu5_Callback(hObject, eventdata, handles)
set(Reference, 'windowstyle', 'modal');
% hObject    handle to menu5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --------------------------------------------------------------------
function menu6_Callback(hObject, eventdata, handles)
set(About, 'windowstyle', 'modal');
% hObject    handle to menu6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --------------------------------------------------------------------
function menu3_Callback(hObject, eventdata, handles)
global AD;
guidata(hObject, handles);
AD = handles;
set(Save, 'windowstyle', 'modal');
% hObject    handle to menu3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --------------------------------------------------------------------
function menu2_Callback(hObject, eventdata, handles)
set(BS, 'Visible', 'off');
set(catalog, 'Visible', 'on');
% hObject    handle to menu2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end



function E1_Callback(hObject, eventdata, handles)
global ngj;
ngj(1) = str2double(get(handles.E1, 'string'));
% hObject    handle to E1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end

% Hints: get(hObject,'String') returns contents of E1 as text
%        str2double(get(hObject,'String')) returns contents of E1 as a double


% --- Executes during object creation, after setting all properties.
function E1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to E1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
end


% --- Executes during object creation, after setting all properties.
function E8_CreateFcn(hObject, eventdata, handles)
% hObject    handle to E8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
end



function E9_Callback(hObject, eventdata, handles)
global gmin;
gmin =  str2double(get(handles.E9, 'string'));
% hObject    handle to E9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of E9 as text
%        str2double(get(hObject,'String')) returns contents of E9 as a double
end


% --- Executes during object creation, after setting all properties.
function E9_CreateFcn(hObject, eventdata, handles)
% hObject    handle to E9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
end



function E10_Callback(hObject, eventdata, handles)
global gmax;
gmax =  str2double(get(handles.E10, 'string'));
% hObject    handle to E10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of E10 as text
%        str2double(get(hObject,'String')) returns contents of E10 as a double
end


% --- Executes during object creation, after setting all properties.
function E10_CreateFcn(hObject, eventdata, handles)
% hObject    handle to E10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
end


function E7_Callback(hObject, eventdata, handles)
global delay_jj;
delay_jj = str2double(get(handles.E7, 'string'));
% hObject    handle to E7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of E7 as text
%        str2double(get(hObject,'String')) returns contents of E7 as a double
end


% --- Executes during object creation, after setting all properties.
function E7_CreateFcn(hObject, eventdata, handles)
% hObject    handle to E7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
end



function E12_Callback(hObject, eventdata, handles)
global k;
k = str2double(get(handles.E12, 'string'));
% hObject    handle to E12 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of E12 as text
%        str2double(get(hObject,'String')) returns contents of E12 as a double
end


% --- Executes during object creation, after setting all properties.
function E12_CreateFcn(hObject, eventdata, handles)
% hObject    handle to E12 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
end



function E11_Callback(hObject, eventdata, handles)
global NUM_FLOWS;
NUM_FLOWS = str2double(get(handles.E11, 'string'));
% hObject    handle to E11 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of E11 as text
%        str2double(get(hObject,'String')) returns contents of E11 as a double
end


% --- Executes during object creation, after setting all properties.
function E11_CreateFcn(hObject, eventdata, handles)
% hObject    handle to E11 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
end



function E2_Callback(hObject, eventdata, handles)
global gamma_ae;
gamma_ae = str2double(get(handles.E2, 'string'));
% hObject    handle to E2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of E2 as text
%        str2double(get(hObject,'String')) returns contents of E2 as a double
end


% --- Executes during object creation, after setting all properties.
function E2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to E2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
end


function E3_Callback(hObject, eventdata, handles)
global gamma_ie;
gamma_ie = str2double(get(handles.E3, 'string'));
% hObject    handle to E3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of E3 as text
%        str2double(get(hObject,'String')) returns contents of E3 as a double
end


% --- Executes during object creation, after setting all properties.
function E3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to E3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
end


function E4_Callback(hObject, eventdata, handles)
global gamma_ah;
gamma_ah =  str2double(get(handles.E4, 'string'));
% hObject    handle to E4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of E4 as text
%        str2double(get(hObject,'String')) returns contents of E4 as a double
end


% --- Executes during object creation, after setting all properties.
function E4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to E4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
end



function E5_Callback(hObject, eventdata, handles)
global Dj;
Dj =  str2double(get(handles.E5, 'string'));
% hObject    handle to E5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of E5 as text
%        str2double(get(hObject,'String')) returns contents of E5 as a double
end


% --- Executes during object creation, after setting all properties.
function E5_CreateFcn(hObject, eventdata, handles)
% hObject    handle to E5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over E1.
function E1_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the cell density, which is normalized so that the value is between 0 and 1.';
set(handles.text5, 'string', str);
% if ~strcmp(get(handles.E1, 'Enable'), 'off')
%     set(handles.E1, 'Enable', 'on');
% end
% hObject    handle to E1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over E2.
function E2_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the enzymatic degradation of aiiA.';
set(handles.text5, 'string', str);
% set(handles.E2, 'Enable', 'on');
% hObject    handle to E2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over E3.
function E3_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the enzymatic degradation of LuxI.';
set(handles.text5, 'string', str);
% set(handles.E3, 'Enable', 'on');
% hObject    handle to E3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over E4.
function E4_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the enzymatic degradation of internal AHL.';
set(handles.text5, 'string', str);
% set(handles.E4, 'Enable', 'on');
% hObject    handle to E4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over E5.
function E5_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes diffusion of AHL through cell membrane.';
set(handles.text5, 'string', str);
% set(handles.E5, 'Enable', 'on');
% hObject    handle to E5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end

% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over E7.
function E7_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the delayed reaction of producing proteins.';
set(handles.text5, 'string', str);
% set(handles.E7, 'Enable', 'on');
% hObject    handle to E7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over E8.
function E8_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the speed of the fluid flow in the microfuidics. It is equal to the parameter which describes the dilution of external AHL by external fluid flow.';
set(handles.text5, 'string', str);
% if ~strcmp(get(handles.E8, 'Enable'), 'off')
%     set(handles.E8, 'Enable', 'on');
% end
% hObject    handle to E8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over E9.
function E9_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the minimum speed of the fluid flow in the microfuidics.';
set(handles.text5, 'string', str);
% if ~strcmp(get(handles.E9, 'Enable'), 'off')
%     set(handles.E9, 'Enable', 'on');
% end
% hObject    handle to E9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over E10.
function E10_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the maximum speed of the fluid flow in the microfuidics.';
set(handles.text5, 'string', str);
% if ~strcmp(get(handles.E10, 'Enable'), 'off')
%     set(handles.E1, 'Enable', 'on');
% end
% hObject    handle to E10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over E12.
function E12_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the trap depth in the microfuidics.';
set(handles.text5, 'string', str);
% set(handles.E12, 'Enable', 'on');
% hObject    handle to E12 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over E11.
function E11_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the step size of the fluid flow speed.';
set(handles.text5, 'string', str);
% if ~strcmp(get(handles.E11, 'Enable'), 'off')
%     set(handles.E11, 'Enable', 'on');
% end
% hObject    handle to E11 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- Executes on button press in C1.
function C1_Callback(hObject, eventdata, handles)
str = 'This allow you to mimic the noisy environment by adding the white noise. The noise will bigger when its value vary from 100 to 0.';
set(handles.text5, 'string', str);
if get(handles.C1, 'value')
    set(handles.E13, 'Enable', 'on');
    set(handles.text20, 'Enable', 'on');
else
    set(handles.E13, 'Enable', 'off');
    set(handles.text20, 'Enable', 'off');
end
% hObject    handle to C1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of C1
end



function E13_Callback(hObject, eventdata, handles)
global dB;
dB = str2double(get(handles.E13, 'string'));
% hObject    handle to E13 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of E13 as text
%        str2double(get(hObject,'String')) returns contents of E13 as a double
end


% --- Executes during object creation, after setting all properties.
function E13_CreateFcn(hObject, eventdata, handles)
% hObject    handle to E13 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
end


% --- Executes on button press in C2.
function C2_Callback(hObject, eventdata, handles)
global AD AD1;
str = 'Fix the fluid flow speed by choosing this item. If you want to analyse the change of oscillation in different speed, do not choose this.';
set(handles.text5, 'string', str);
if get(hObject, 'Value')
    set(handles.E8, 'Enable', 'on');
    set([handles.E9 handles.E10 handles.E11], 'Enable', 'off');
else
    set([handles.E9 handles.E10 handles.E11], 'Enable', 'on');
    set(handles.E8, 'Enable', 'off');
end
guidata(hObject, handles);
AD1 =  handles;
AD = handles;
% hObject    handle to C2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of C2
end


% --- Executes on button press in pb5.
function pb5_Callback(hObject, eventdata, handles)
set(handles.pb5, 'Enable', 'off');
set(handles.pb6, 'Enable', 'on');
axes(handles.axes2);
imshow(handles.M3);
% hObject    handle to pb5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- Executes on button press in pb6.
function pb6_Callback(hObject, eventdata, handles)
set(handles.pb6, 'Enable', 'off');
set(handles.pb5, 'Enable', 'on');
axes(handles.axes2);
M2 = imread('S2.jpg');
imshow(M2);
% hObject    handle to pb6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- Executes on button press in C3.
function C3_Callback(hObject, eventdata, handles)
global AD1 AD;
str = 'Fix the cell density by choosing this item. If you want to analyse the change of oscillation in different density, do not choose this.';
set(handles.text5, 'string', str);
if get(hObject, 'Value')
    set(handles.E1, 'Enable', 'on');
    set([handles.E14 handles.E15 handles.E16], 'Enable', 'off');
else
    set(handles.E1, 'Enable', 'off');
    set([handles.E14 handles.E15 handles.E16], 'Enable', 'on');
end
guidata(hObject, handles);
AD1 =  handles;
AD = handles;
% hObject    handle to C3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of C3
end



function E14_Callback(hObject, eventdata, handles)
global dmin;
dmin = str2double(get(handles.E14, 'string'));
% hObject    handle to E14 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of E14 as text
%        str2double(get(hObject,'String')) returns contents of E14 as a double
end


% --- Executes during object creation, after setting all properties.
function E14_CreateFcn(hObject, eventdata, handles)
% hObject    handle to E14 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
end



function E15_Callback(hObject, eventdata, handles)
global dmax;
dmax = str2double(get(handles.E15, 'string'));
% hObject    handle to E15 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of E15 as text
%        str2double(get(hObject,'String')) returns contents of E15 as a double
end


% --- Executes during object creation, after setting all properties.
function E15_CreateFcn(hObject, eventdata, handles)
% hObject    handle to E15 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
end



function E16_Callback(hObject, eventdata, handles)
global dstep;
dstep = str2double(get(handles.E16, 'string'));
% hObject    handle to E16 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of E16 as text
%        str2double(get(hObject,'String')) returns contents of E16 as a double
end


% --- Executes during object creation, after setting all properties.
function E16_CreateFcn(hObject, eventdata, handles)
% hObject    handle to E16 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over E14.
function E14_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the minimum of the cell density.';
set(handles.text5, 'string', str);
% if ~strcmp(get(handles.E14, 'Enable'), 'off')
%     set(handles.E14, 'Enable', 'on');
% end
% hObject    handle to E14 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over E15.
function E15_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the maximum of the cell density.';
set(handles.text5, 'string', str);
% if ~strcmp(get(handles.E15, 'Enable'), 'off')
%     set(handles.E15, 'Enable', 'on');
% end
% hObject    handle to E15 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over E16.
function E16_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the step size of the cell density.';
set(handles.text5, 'string', str);
% if ~strcmp(get(handles.E16, 'Enable'), 'off')
%     set(handles.E16, 'Enable', 'on');
% end
% hObject    handle to E16 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- Executes when user attempts to close BS.
function BS_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to BS (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: delete(hObject) closes the figure
sel = questdlg('Are you sure to close?', 'Close confirm', 'Yes', 'No', 'No');
switch sel
    case 'Yes'
        clear all;
        delete(BS);
    case 'No'
        return;
end
end


% --------------------------------------------------------------------
function menu7_Callback(hObject, eventdata, handles)
pb2_Callback(hObject, eventdata, handles)
% hObject    handle to menu7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- Executes during object creation, after setting all properties.
function pb2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to pb2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
end


% --------------------------------------------------------------------
function menu8_Callback(hObject, eventdata, handles)
global AD AD1;
[fName pName ~] = uigetfile('*.xls', 'Load files', 'parameters.xls');
str = [pName fName];
[~,~,raw] = xlsread(str);
par = raw(:, 2);
for i = 1:numel(par)
    if isnan(par{i})
        par{i} = '';
    else
        par{i}=num2str(par{i});
    end
end
set(handles.E1, 'string', par{2});
set(handles.E14, 'string', par{3});
set(handles.E15, 'string', par{4});
set(handles.E16, 'string', par{5});
set(handles.E4, 'string', par{6});
set(handles.E3, 'string', par{7});
set(handles.E2, 'string', par{8});
set(handles.E5, 'string', par{9});
set(handles.E7, 'string', par{10});
set(handles.E8, 'string', par{12});
set(handles.E9, 'string', par{13});
set(handles.E10, 'string', par{14});
set(handles.E11, 'string', par{15});
set(handles.E12, 'string', par{16});
set(handles.E13, 'string', par{17});
guidata(hObject, handles);
AD = handles;
AD1 = handles;
% hObject    handle to menu8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over text7.
function text7_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the cell density, which is normalized so that the value is between 0 and 1.';
set(handles.text5, 'string', str);
% hObject    handle to text7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- Executes during object creation, after setting all properties.
function text7_CreateFcn(hObject, eventdata, handles)
% hObject    handle to text7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over text21.
function text21_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the minimum of the cell density.';
set(handles.text5, 'string', str);
% hObject    handle to text21 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- Executes during object creation, after setting all properties.
function text21_CreateFcn(hObject, eventdata, handles)
% hObject    handle to text21 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over text22.
function text22_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the maximum of the cell density.';
set(handles.text5, 'string', str);
% hObject    handle to text22 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- Executes during object creation, after setting all properties.
function text22_CreateFcn(hObject, eventdata, handles)
% hObject    handle to text22 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over text23.
function text23_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the step size of the cell density.';
set(handles.text5, 'string', str);
% hObject    handle to text23 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- Executes during object creation, after setting all properties.
function text23_CreateFcn(hObject, eventdata, handles)
% hObject    handle to text23 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over text10.
function text10_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the enzymatic degradation of internal AHL.';
set(handles.text5, 'string', str);
% hObject    handle to text10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- Executes during object creation, after setting all properties.
function text10_CreateFcn(hObject, eventdata, handles)
% hObject    handle to text10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over text12.
function text12_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes diffusion of AHL through cell membrane.';
set(handles.text5, 'string', str);
% hObject    handle to text12 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- Executes during object creation, after setting all properties.
function text12_CreateFcn(hObject, eventdata, handles)
% hObject    handle to text12 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over text14.
function text14_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the delayed reaction of producing proteins.';
set(handles.text5, 'string', str);
% hObject    handle to text14 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- Executes during object creation, after setting all properties.
function text14_CreateFcn(hObject, eventdata, handles)
% hObject    handle to text14 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over text9.
function text9_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the enzymatic degradation of LuxI.';
set(handles.text5, 'string', str);
% hObject    handle to text9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- Executes during object creation, after setting all properties.
function text9_CreateFcn(hObject, eventdata, handles)
% hObject    handle to text9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over text13.
function text13_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the enzymatic degradation of aiiA.';
set(handles.text5, 'string', str);
% hObject    handle to text13 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- Executes during object creation, after setting all properties.
function text13_CreateFcn(hObject, eventdata, handles)
% hObject    handle to text13 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over text15.
function text15_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the speed of the fluid flow in the microfuidics. It is equal to the parameter which describes the dilution of external AHL by external fluid flow.';
set(handles.text5, 'string', str);
% hObject    handle to text15 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- Executes during object creation, after setting all properties.
function text15_CreateFcn(hObject, eventdata, handles)
% hObject    handle to text15 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over text19.
function text19_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the minimum speed of the fluid flow in the microfuidics.';
set(handles.text5, 'string', str);
% hObject    handle to text19 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- Executes during object creation, after setting all properties.
function text19_CreateFcn(hObject, eventdata, handles)
% hObject    handle to text19 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over text18.
function text18_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the maximum speed of the fluid flow in the microfuidics.';
set(handles.text5, 'string', str);
% hObject    handle to text18 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- Executes during object creation, after setting all properties.
function text18_CreateFcn(hObject, eventdata, handles)
% hObject    handle to text18 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over text16.
function text16_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the step size of the fluid flow speed.';
set(handles.text5, 'string', str);
% hObject    handle to text16 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- Executes during object creation, after setting all properties.
function text16_CreateFcn(hObject, eventdata, handles)
% hObject    handle to text16 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over text17.
function text17_ButtonDownFcn(hObject, eventdata, handles)
str = 'This parameter describes the trap depth in the microfuidics.';
set(handles.text5, 'string', str);
% hObject    handle to text17 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
end


% --- Executes during object creation, after setting all properties.
function text17_CreateFcn(hObject, eventdata, handles)
% hObject    handle to text17 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
end



function E8_Callback(hObject, eventdata, handles)
global g;
g =  str2double(get(handles.E8, 'string'));
% hObject    handle to E8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of E8 as text
%        str2double(get(hObject,'String')) returns contents of E8 as a double
end
